/*
 * fsm.h
 *
 *  Created on: Oct 18, 2024
 *      Author: akeguo
 */

#ifndef INC_FSM_H_
#define INC_FSM_H_
#include "stdint.h"

#define       AUTO_MODE       -1000
#define       MANUAL_MODE     0
#define       HOME_MODE       1000
#define       AUTO_SWIGN      1000
#define       AUTO_TILT       -1000

typedef enum _MoveSTATE_t
{
	Move_HALT=0,
	Manual_State,
	Auto_Back_State,
} MoveSTATE_t;

//设置  换道距离和设置后退距离
typedef enum _SetSTATE_t
{
	OtherMode=0,
	SetLaneChangeDistance,
	SetBackwardsDistance,
} SetSTATE_t;

typedef enum _SwingSTATE_t
{
	SwingHALT = 0,
	SwingAuto,
	SwingManual,
	SwingHome,
} SwingSTATE_t;

typedef enum _TiltSTATE_t
{
	TiltHALT = 0,
	TiltAuto,
	TiltManual,
	TiltHome
} TiltSTATE_t;



typedef struct _transition_t
{
	int State; //状态
	void (*robotRun)(void); //执行相关动作
} transition_t;


extern int32_t* RobotSpeed;
extern int32_t *JontSwingSpeed;
extern int32_t *JontTiltSpeed;
void Fsm_Init();
#endif /* INC_FSM_H_ */
