

#ifndef INC_BSP_UART_H_
#define INC_BSP_UART_H_

#include "bsp_include.h"
#include "main.h"
#include "bsp_Error.pb.h"


#define UART_Transmit_MAX_NUM 1024
#define UART_Receive_MAX_NUM 100

extern struct UARTHandler RS_485_1_UART_Handler;
extern struct UARTHandler RS_485_2_UART_Handler;
extern struct UARTHandler RS_485_3_UART_Handler;
extern struct UARTHandler RS_485_4_UART_Handler;
extern struct UARTHandler InterCall_DEBUG_UART_Handler;
extern struct UARTHandler E28_SBUS_UART_Handler;
extern struct UARTHandler LTE_7S0_Serial_UART_Handler;

//#define InterCall_DEBUG_UART huart4
#define E28_SBUS_UART hlpuart1
//#define RS485_4_UART huart7
#define RS485_1_UART huart1
#define RS485_2_UART huart2
#define RS485_3_UART huart3

#if defined (hlpuart1Exit)
	extern struct UARTHandler LPUART1_UART_Handler;

#endif

uint8_t GF_BSP_UART_Init(void);

void GF_BSP_UARTHandlers_Intialize(
		int32_t RS485_1_WaitTime,
		int32_t RS485_2_WaitTime,
		int32_t RS485_3_WaitTime,
		int32_t RS485_4_WaitTime,
		int32_t LTE_7S0_Serial_WaitTime,
		int32_t InterCall_DEBUG_WaitTime,
		int32_t E28_SBUS_WaitTime,
		int32_t LPUART1_UART_WaitTime,
		int32_t RS485_1_Dispacher_Time,
		int32_t RS485_2_Dispacher_Time,
		int32_t RS485_3_Dispacher_Time,
		int32_t RS485_4_Dispacher_Time,
		int32_t LTE_7S0_Serial_Dispacher_Time,
		int32_t InterCall_DEBUG_Dispacher_Time,
		int32_t E28_SBUS_Dispacher_Time,
		int32_t LPUART1_UART_Dispacher_Time
);

//串行发送完成后才能发送第二帧数据，没有做缓冲，如未发送完成，第二次发送无效，丢弃发送数据
void GF_BSP_UART_Transmit(const uint8_t RS485_Index,const uint8_t *pData, uint16_t Size);




typedef struct  UARTSendHandler
{
	uint16_t SendLength;
	uint16_t SendListTimePeriod;
	uint8_t Tx_Buf[502];
	void (*UART_Decode)(uint8_t*, uint16_t);     // 发送缓存
	struct UARTSendHandler* pNext;
}UARTSendHandler;


struct UARTHandler
{
	char startCountFlag;                         //indicate that to start counting
	char send_finished;                          //indicate send finished or not
	char decode_finished;                        //indicate decode finished or not
	uint8_t tmp_Rx_Buf[2];                       // temporary data to store received data

	uint32_t Wait_time;                          // the time to wait
	uint32_t Wait_Time_Count;
	uint32_t SendList_time_Count;

	uint32_t SendList_Period;
	uint8_t SendListExists;

	UART_HandleTypeDef* uart;                    //UART to use

	UARTSendHandler *pCurrentUARTSendHadler;     //这个结构体指针是用来干什么的？


	unsigned char timeSpan;                      // timer elapsed time
	uint8_t Rx_Buf[2048];                        // 接收缓存,最大256字节
	uint8_t Tx_Buf[2048];                        //发送缓存 157,864
	uint16_t TxCount;

	uint16_t RxCount;

	void (*UART_Tx)(struct UARTHandler*);        //void UART_Tx(uint8_t *Tx_Buf,uint16_t TxCount);
	void (*UART_Rx)(struct UARTHandler*);
	void (*UART_Decode)(uint8_t*, uint16_t);     //Decode Rx_Buf

	void (*AddSendList)(struct UARTHandler*,
						uint8_t*,
						uint16_t,
						uint32_t,                //这里是修改等待时间
						void (*UART_Decode)(uint8_t*, uint16_t));

	struct _DispacherController *dispacherController;

};

void UARTHandlerTx(struct UARTHandler *uartHandler);
void UARTHandlerRX(struct UARTHandler *uartHandler);
//void IntializeUARTHandler(struct UARTHandler *uartHandler, UART_HandleTypeDef uart,int32_t WaitTime,unsigned char timeSpan);
void Counting(struct UARTHandler *uartHandler);


void IntializeUARTHandler(struct UARTHandler *uartHandler,
		UART_HandleTypeDef *uart, int32_t WaitTime, unsigned char timeSpan,int32_t Dispacher_Time);
void GF_BSP_UART_Timer();

#endif /* INC_BSP_UART_H_ */
