/*
 * robot_state.h
 *
 *  Created on: Aug 2, 2024
 *      Author: akeguo
 */

#ifndef INC_ROBOT_STATE_H_
#define INC_ROBOT_STATE_H_

#include "BHBF_ROBOT.h"
#include "bsp_include.h"

extern uint8_t Pit_flag;
extern int32_t Pit_Position_fir;
extern int32_t Pit_Position_sec;
extern int32_t Rot_Position_fir;
extern int32_t Rot_Position_sec;
extern uint8_t Rot_dir_flag;
extern uint8_t Pitch_dir_flag;
extern double Act_Speed;
extern double RP_speed_act;
extern double Pit_time;
extern double Rot_time;

void Manual_State_Entry(void);
void Manual_State_Do(void);
void Auto_Back_State_Do(void);

void LaneChangeDistance_Setting_State_Do(void);
void BackWardsDistance_Setting_State_Do(void);
void Auto_State_Do(void);
void Abnormal_State_Do(void);
//前进、后退、左转、右转
void Forwards_State_Do(void);
void Backwards_State_Do(void);
void TurnLeft_State_Do(void);
void TurnRight_State_Do(void);

void HALT_State_Do(void);//停止


void SwingHALT_State_Do(void);
void SwingLeft_State_Do(void);
void SwingRight_State_Do(void);
void SwingAuto_Do(void);
void SwingManual_Do(void);
void SwingHome_Do(void);


void SetLaneChangeDistance_State_Do(void);
void SetBackwardsDistance_State_Do(void);
void OtherMode_State_Do(void);



void TiltUp_Do();
void TiltDown_Do();
void TiltHalt_Do();
void TiltAuto_Do(void);
void TiltManual_Do(void);
void TiltHome_Do();


void TiltCurrentModeDown_Do();


#endif /* INC_ROBOT_STATE_H_ */
