/*
 * bsp_com_helper.h
 *
 *  Created on: Oct 9, 2024
 *      Author: akeguo
 */

#ifndef INC_BSP_BSP_COM_HELPER_H_
#define INC_BSP_BSP_COM_HELPER_H_
#include "bsp_include.h"


typedef struct _Dispatcher
{
	//uint8_t IsDeleted;
	void (*dispache)(void);

	//struct _Dispatcher* pBefore;
	struct _Dispatcher* pNext;
}Dispatcher;


//通讯链表节点结构体
typedef struct _ComHardWare
{
	//void (*dispache)(void);
	char Name[50];
	char IsOnline;
	uint32_t BitFlag;
	struct _ComHardWare* pNext;
}ComHardWare;


typedef struct _DispacherController
{
	Dispatcher *pHead; // = NULL;                                   //环形链表中的数据头指针
	Dispatcher *pTail; // = NULL;                                   //环形链表中的数据尾指针
	uint16_t DispacherNumber;
	uint16_t DispacherCallTime;
	uint16_t Dispacher_Counter;
	uint16_t Dispacher_Enable;                                      // = 0 disable 1 enable

	void (*Add_Dispatcher_List)(struct _DispacherController* ,
								void (*dispacher)(void));           //链表添加调度程序

	void (*Dispatcher_Run)(struct _DispacherController* );          //运行调度程序

}DispacherController;

typedef struct _HardWareController
{
	  struct _ComHardWare *pComHWHead;
	  struct _ComHardWare *pComHWTail;
	uint16_t HardWare_Check_Counter;
	uint16_t DispacherCallTime; //= 100; //2ms 一次，
	void (*Add_PCOMHardWare)(struct _HardWareController *, char* , char ,uint32_t);
	void (*PCOMHardWare_Check)(struct _HardWareController *);
	int (*Set_PCOMHardWare)(struct _HardWareController *, char* , char );


} HardWareController;




 void Dispatch_t(DispacherController *uartHandler);

void Dispatcher_List_Add_t(DispacherController *uartHandler,void (*dispache)(void));
// void Dispatcher_List_Add_t(DispacherController *uartHandler,
// 		void (*dispache)(void),void (*Decode)(uint8_t*, uint16_t));
// void ComHardWare_List_Add_t(HardWareController *uartHandler, char *name,char value);

 void PCOMHardWare_Check_t(HardWareController *uartHandler);

int Set_PCOMHardWare_t(HardWareController *uartHandler, char *name, char value);

void ComHardWare_List_Add_t(HardWareController *uartHandler, char *name,
		char value,uint32_t bitFlag);


#endif /* INC_BSP_BSP_COM_HELPER_H_ */
