/*
 * bsp_pv_setting.c
 *
 *  Created on: Jan 8, 2025
 *      Author: akeguo
 */
#include <bsp_client_setting.h>
#include "BHBF_ROBOT.h"

#include "bsp_UART.h"

void UpdateIV();
void decode_received_data_from_client(uint8_t *buffer, uint16_t length);

struct UARTHandler *client_setting_Handler;
DispacherController *client_setting_dispacher;

void client_setting_intialize(struct UARTHandler *Handler)
{

	client_setting_Handler = Handler;
	client_setting_Handler->Wait_time = 6; //  最低不要低于4；

	client_setting_dispacher = Handler->dispacherController;
	client_setting_dispacher->Dispacher_Enable=1;//不周期性发送
	client_setting_dispacher->DispacherCallTime = 500;
	client_setting_dispacher->Add_Dispatcher_List(client_setting_dispacher,
	        UpdateIV);



	client_setting_Handler->UART_Decode = decode_received_data_from_client; //indicate that there is no need to listen

}

void UpdateIV()
{

	pb_ostream_t IV_o_stream = pb_ostream_from_buffer(
	        &client_setting_Handler->Tx_Buf[2],
	        sizeof(client_setting_Handler->Tx_Buf) - 2);
	pb_encode(&IV_o_stream, IV_struct_define_fields, &IV);

	client_setting_Handler->Tx_Buf[0] = 0x55;
	client_setting_Handler->Tx_Buf[1] = 0x55;
	client_setting_Handler->TxCount = IV_o_stream.bytes_written + 4;

	uint16_t crc=MB_CRC16(&(client_setting_Handler->Tx_Buf[0]),  IV_o_stream.bytes_written + 2);

	client_setting_Handler->Tx_Buf[IV_o_stream.bytes_written + 2] = (crc>>8) &0xff;
	client_setting_Handler->Tx_Buf[IV_o_stream.bytes_written + 3] =  crc & 0xff;;

	client_setting_Handler->UART_Tx(client_setting_Handler);
}

void decode_received_data_from_client(uint8_t *buffer, uint16_t length)
{
	if(length>100)
	{
		return;
	}
	uint8_t data[100];
	memcpy(data,buffer,length);

	//if (*buffer == 0x55 && *(buffer + 1) == 0x55 && length >= 4)
	if (buffer[0] == 0x55 && buffer[1] == 0x55 && length >= 4)
	{
		uint16_t crc_check = ((buffer[length - 1] << 8) | buffer[length - 2]);
		uint16_t crc_check1 = MB_CRC16(buffer, length - 2);
		/* CRC 校验正确 */
		if (crc_check == MB_CRC16(buffer, length - 2))
		{
			//if (*(buffer + 2) == 0x01 && *(buffer + 3) == 0x01) //01 01 设置PV
			if (buffer[2] == 0x01 && buffer[3] == 0x01) //01 01 设置PV
			{
				PV_struct_define decoded_PV = PV_struct_define_init_default;
				pb_istream_t i_pv_stream =
				{ 0 };

				i_pv_stream = pb_istream_from_buffer(&buffer[4], length - 4);
				pb_decode(&i_pv_stream, PV_struct_define_fields, &decoded_PV);
				//将CV写入EEPROM
				//CV_struct_define saved_cV = GF_BSP_EEPROM_Get_CV();
				GV.PV = decoded_PV;
				//GF_BSP_EEPROM_Set_CV(CV);
			}
			else if (*(buffer + 2) == 0x02 && *(buffer + 3) == 0x01) //设置PV
			{

			}
			else if (*(buffer + 2) == 0x03 && *(buffer + 3) == 0x01) //返回IV
			{

			}
			else
			{

			}

		}
		else
		{
			//Decode Error；
			//log_error("wire sensor decoding failed");
//			LOGFF(DL_ERROR, "androidd decoding failed");

		}

	}

//	client_setting_Handler->Tx_Buf[0]='1';
//	client_setting_Handler->Tx_Buf[1]=',';
//		//wh_LTE_7S0_Handler->Tx_Buf[2]='1';
//	client_setting_Handler->TxCount =  2;
//	client_setting_Handler->UART_Tx(client_setting_Handler);
}

