/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "dma.h"
#include "usart.h"
#include "tim.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "msp_Steering_Engine.h"
#include "BHBF_ROBOT.h"
#include <bsp_client_setting.h>

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
  void CV_GV_Init();
  void GF_Robot_Init();
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
//  int can1_sendListPeriod = 10;
//  int can1_DispacherPeriod = 4;
//  int can2_sendListPeriod = 20;
//  int can2_DispacherPeriod = 20;

  #define RS485_1_WaitTime  40
  #define RS485_2_WaitTime 40
  #define RS485_3_WaitTime 40
  #define RS485_4_WaitTime 40
  #define LTE_7S0_Serial_WaitTime 40
  #define InterCall_DEBUG_WaitTime 40
  #define E28_SBUS_WaitTime 6
  #define LPUART1_UART_WaitTime 40
  #define RS485_1_Dispacher_Time 100
  #define RS485_2_Dispacher_Time 100
  #define RS485_3_Dispacher_Time 100
  #define RS485_4_Dispacher_Time 100
  #define LTE_7S0_Serial_Dispacher_Time 100
  #define InterCall_DEBUG_Dispacher_Time 100
  #define E28_SBUS_Dispacher_Time  100
  #define LPUART1_UART_Dispacher_Time 100
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
uint8_t sendcode[4]={0x01,0x03,0x07,0x1A};
uint8_t sbus_Receive[32];
void GF_Robot_MainLoop();
/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_USART1_UART_Init();
  MX_LPUART1_UART_Init();
  MX_USART2_UART_Init();
  MX_TIM1_Init();
  MX_TIM8_Init();
  MX_USART3_UART_Init();
  /* USER CODE BEGIN 2 */
  //HAL_UART_Receive_IT(&huart3, sbus_Receive, 3);

//  GF_BSP_Interrupt_Add_CallBack(
//		  DF_BSP_InterCall_TIM1_100ms_PeriodElapsedCallback,
//  			GF_Robot_MainLoop);
  GF_BSP_TIMER_Init();
  GF_Robot_Init();

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
//	  HAL_UART_Transmit(&huart1, sendcode, 4, 100);
//	  HAL_UART_Transmit(&huart3, sendcode, 4, 100);
//	  HAL_Delay(1000);
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */

  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1_BOOST);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLM = RCC_PLLM_DIV1;
  RCC_OscInitStruct.PLL.PLLN = 20;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLQ = RCC_PLLQ_DIV8;
  RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_4) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */

void CV_GV_Init()
{
	P_MK32 = &GV.MK32_Key;

	//RobotSpeed = &GV.Move_Speed;

	Desulfurizer_Steering_Set_Speed_1 = &GV.Servo_Speed_1;
	Desulfurizer_Steering_Set_Speed_2 = &GV.Servo_Speed_2;
	Desulfurizer_Steering_Set_Speed_3 = &GV.Servo_Speed_3;
	Desulfurizer_Steering_Set_Speed_4 = &GV.Servo_Speed_4;

	Steering_damping_power_1 = &GV.Servo_Power_1;
	Steering_damping_power_2 = &GV.Servo_Power_2;
	Steering_damping_power_3 = &GV.Servo_Power_3;
	Steering_damping_power_4 = &GV.Servo_Power_4;

	Desulfurizer_Steering_Angle_3 = &GV.Steering_Angle_3;
	Desulfurizer_Steering_Angle_4 = &GV.Steering_Angle_4;

	GV.Steering_Angle_3 = 90;
	GV.Steering_Angle_4 = 38;

	Desulfurizer_Steering_Real_Angle_3 = &GV.Steering_Real_Angle_3;
	Desulfurizer_Steering_Real_Angle_4 = &GV.Steering_Real_Angle_4;
}

void GF_Robot_Init()
{

	uint8_t _state = 1;

	Fsm_Init();

	//2ms调度
	//GF_BSP_EEPROM_Init();
	CV_GV_Init();


//	//初始化encoder
	GF_BSP_UARTHandlers_Intialize(RS485_1_WaitTime,
								  RS485_2_WaitTime,
								  RS485_3_WaitTime,
								  RS485_4_WaitTime,
								  LTE_7S0_Serial_WaitTime,
								  InterCall_DEBUG_WaitTime,
								  E28_SBUS_WaitTime,
								  LPUART1_UART_WaitTime,
								  RS485_1_Dispacher_Time,
								  RS485_2_Dispacher_Time,
								  RS485_3_Dispacher_Time,
								  RS485_4_Dispacher_Time,
								  LTE_7S0_Serial_Dispacher_Time,
								  InterCall_DEBUG_Dispacher_Time,
								  E28_SBUS_Dispacher_Time,
								  LPUART1_UART_Dispacher_Time);                //已读

	MK32_Sbus_UART_Handler_intialize(&LPUART1_UART_Handler);

	steering_engine_intialize(&RS_485_1_UART_Handler);

	client_setting_intialize(&RS_485_3_UART_Handler);

	_state = _state & GF_BSP_TIMER_Init();


}

//int32_t a = 0;
//void GF_Robot_MainLoop()
//{
//	a++;
//
//	if(a>=5)
//	{
//		a= 0;
//		HAL_UART_Transmit(&huart1, sendcode, 4, 100);
//	}
//
//}
/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
