import socket
import json
import time

import numpy as np
import math


# 连接机器人控制器
def connectETController(ip, port=8055):
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        sock.connect((ip, port))
        return (True, sock)
    except Exception as e:
        sock.close()
        return (False,)


# 发送命令并接收响应
def sendCMD(sock, cmd, params=None, id=1):
    if not params:
        params = []
    else:
        params = json.dumps(params)
    sendStr = '{"method":"%s","params":%s,"jsonrpc":"2.0","id":%d}' % (cmd, params, id) + "\n"
    try:
        sock.sendall(bytes(sendStr, "utf-8"))
        ret = sock.recv(1024)
        jdata = json.loads(str(ret, "utf-8"))
        if "result" in jdata.keys():
            return (True, json.loads(jdata["result"]), jdata["id"])
        elif "error" in jdata.keys():
            return (False, jdata["error"], jdata["id"])
        else:
            return (False, None, None)
    except Exception as e:
        return (False, None, None)


def send_Point(sock, cmd, params=None, id=1):
    if (not params):
        params = []
    else:
        params = json.dumps(params)
    sendStr = "{{\"method\":\"{0}\",\"params\":{1},\"jsonrpc\":\"2.0\",\"id\":{2}}}".format(cmd, params, id) + "\n"
    sock.sendall(bytes(sendStr, "utf-8"))


def wait_stop(sock):  # 修正：添加sock参数
    while True:
        time.sleep(0.01)
        ret1, result1, id1 = sendCMD(sock, "getRobotState")  # getRobotstate
        if (ret1):
            if result1 == 0 or result1 == 4:
                break
            else:
                print("getRobotState failed")
                break

#需要做8端程序，
# 第1段，起点处的关节位置（txt）；第2段，上升喷涂（txt）；
# 第3段，起点初的关节位置（txt）；第4段，上升喷涂（txt）；
# 第5段，起点初的关节位置（txt）；第6段，上升喷涂（txt）；
# 第7段，起点初的关节位置（txt）；第8段，上升喷涂（txt）；



# 第一段程序封装为函数
def program1(sock):
    i = 0
    ###大臂车补偿量
    increments = [100, 100, 100, 0, 0, 0]  # 大臂车的位姿误差只补偿空间位置不补偿姿态，所有后面3个都是0；
    ###大臂车补偿量
    reference_pos = None  # 初始化参考位置
    new_joint_pos = None  # 初始化逆解得到的新关节位置

    # 打开Pose_1.txt获取第一组末端位姿并计算target_pose
    pose_file = open('Pose_1.txt', "r")
    first_pose_line = pose_file.readline().strip()  # 读取第一组位姿
    if first_pose_line:
        Path_First_Position = list(map(float, first_pose_line.split(',')))
        Modified_First_Position = [val + inc for val, inc in zip(Path_First_Position, increments)]
        target_pose = Modified_First_Position  # 将修改后的位姿列表 Modified_First_Position 赋值给 target_pose，作为目标位姿使用
    else:
        print("Pose_1.txt为空，无法获取初始位姿")
        pose_file.close()
        return
    pose_file.close()

    # 打开关节位置文件
    file_name = 'joint_positions_assembled_1.txt'
    fo = open(file_name, "r")
    while 1:
        line = fo.readline()
        if not line:
            break
        line_list = line.strip()
        line_list = list(map(float, line_list.split(',')))

        # 取出第一组关节位置A作为参考位置，并计算新关节位置
        if reference_pos is None:
            reference_pos = line_list  # A组关节位置赋值给参考位置
            # 调用逆解函数计算新关节位置
            suc, angle, id = sendCMD(sock, "inverseKinematic", {"targetPose": target_pose, "referencePos": reference_pos})
            if suc and angle is not None:
                new_joint_pos = angle  # 保存逆解得到的新关节位置
            else:
                print("逆解计算失败，使用原有关节位置")
                new_joint_pos = line_list  # 失败时使用原位置

        # 用新关节位置覆盖原有位置（A、B、C均使用新位置）
        modified_list = new_joint_pos if new_joint_pos is not None else line_list

        print(modified_list)
        if (i == 0):
            # 关节运动到起始点
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            print(result)
            wait_stop(sock)  # 等待机器人停止
            print(1)
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
            print(result)
        # 添加透传伺服目标关节点信息到缓存中
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
        print(result)
        time.sleep(0.01)
        i = i + 1
    fo.close()
    print("第一段程序执行完")



# 第二段程序封装为函数
def program2(sock):
    i = 0
    # 清空透传缓存
    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
    time.sleep(0)
    print("第二段程序开始执行")
    file_name = 'Pose_1.txt'
    fo = open(file_name, "r")
    while 1:
        line = fo.readline()
        if not line:
            break
        line_list = line.strip()
        line_list = list(map(float, line_list.split(',')))
        increments = [100, 100, 100, 0, 0, 0]
        modified_list = [val + inc for val, inc in zip(line_list, increments)]

        print(modified_list)
        if (i == 0):
            # 关节运动到起始点
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            print(result)
            wait_stop(sock)  # 等待机器人停止
            print(1)
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 100, "t": 100, "smoothness": 1, "response_enable": 0})
            print(result)
        # 添加透传伺服目标关节点信息到缓存中
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPose": modified_list})

        print(result)
        time.sleep(0.1)
        i = i + 1
    fo.close()
    print("第二段程序执行完")


# 第三段程序封装为函数（保留原功能，可根据需要选择执行）
def program3(sock):
    i = 0
    # 清空透传缓存
    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
    time.sleep(0)
    print("第三段程序开始执行")
    file_name = 'joint_positions_assembled_1.txt'
    fo = open(file_name, "r")
    while 1:
        line = fo.readline()
        if not line:
            break
        line_list = line.strip()
        line_list = list(map(float, line_list.split(',')))
        increments = [0, 0, 0, 0, 0, 0]
        modified_list = [val + inc for val, inc in zip(line_list, increments)]

        print(modified_list)
        if (i == 0):
            # 关节运动到起始点
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 80})
            print(result)
            wait_stop(sock)  # 等待机器人停止
            print(1)
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
            print(result)
        # 添加透传伺服目标关节点信息到缓存中
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
        print(result)
        time.sleep(0.01)
        i = i + 1
    fo.close()
    print("第三段程序执行完")


if __name__ == "__main__":
    # 机器人IP地址
    robot_ip = "192.168.1.100"
    result = connectETController(robot_ip)
    sock = None
    if len(result) == 2:
        conSuc, sock = result
        if conSuc:
            print("成功连接到机器人")
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "get_transparent_transmission_state")
            if id == 1:
                print(suc, result, id)
                if result == 1:
                    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
                    print("已清空透传缓存")
                    time.sleep(0.5)
                else:
                    print("无缓存")

            # 在此处做检测等相关操作
            suc, result, id = sendCMD(sock, "getRobotState")
            if (result == 4):
                # 清除报警
                suc, result, id = sendCMD(sock, "clearAlarm")
                time.sleep(0.5)

            # 获取同步状态
            suc, result, id = sendCMD(sock, "getMotorStatus")
            if (result == 0):
                # 同步伺服编码器数据
                suc, result, id = sendCMD(sock, "syncMotorStatus")
                time.sleep(0.5)
            else:
                print("同步状态获取失败")

            # 获取机械臂伺服状态
            suc, result, id = sendCMD(sock, "getServoStatus")
            if (result == 0):
                # 设置机械臂伺服状态ON
                suc, result, id = sendCMD(sock, "set_servo_status", {"status": 1})
                time.sleep(1)
            else:
                print("机械臂伺服取失败")

            # 获取当前机器人是否处于透传状态
            suc, result, id = sendCMD(sock, "get_transparent_transmission_state")
            print(result)
            if (result == 1):
                # 清空透传缓存
                suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
                time.sleep(0.5)
            else:
                print("非缓存状态")

            time.sleep(0.01)
            print("初始化完成，等待指令...")

            # 用字典模拟switch-case逻辑
            program_switch = {
                1: program1,
                2: program2,
                3: program3  # 保留第三段程序的选择入口
            }

            # 循环等待用户输入选择
            while True:
                try:
                    choice = input("\n请选择执行的程序 (1-第一段, 2-第二段, 3-第三段, q-退出): ")
                    if choice.lower() == 'q':
                        print("程序退出")
                        break
                    choice_num = int(choice)
                    if choice_num in program_switch:
                        program_switch[choice_num](sock)  # 执行对应程序
                    else:
                        print("无效选择，请输入1、2、3或q")
                except ValueError:
                    print("输入错误，请输入数字或q")
        else:
            print("连接机器人失败")
    else:
        print("无法连接到机器人")

    # 关闭连接
    if sock:
        sock.close()