/*
 * bsp_include.h
 *
 *  Created on: Oct 26, 2023
 *      Author: shiya
 */

#ifndef INC_BSP_INCLUDE_H_
#define INC_BSP_INCLUDE_H_

#include "main.h"
#include "dma.h"
#include "fdcan.h"
#include "tim.h"
#include "usart.h"
#include "gpio.h"

#include "bsp_TIMER.h"




//一个中断回调函数支持多少个回调函数链接
#define DF_BSP_InterCall_Num 20

//一共支持多少种中断函数
#define DF_BSP_InterCall_Type_Num 11

enum DF_BSP_InterCall_Type
{
	DF_BSP_InterCall_FDCAN1_RxFifo0Callback = 0,
	DF_BSP_InterCall_FDCAN2_RxFifo0Callback,
	DF_BSP_InterCall_RS485_1_RxCpltCallback,
	DF_BSP_InterCall_RS485_2_RxCpltCallback,
	DF_BSP_InterCall_RS485_3_RxCpltCallback,
	DF_BSP_InterCall_RS485_4_RxCpltCallback,
	DF_BSP_InterCall_DEBUG_RxCpltCallback,
	DF_BSP_InterCall_E22_Serial_RxCpltCallback,
	DF_BSP_InterCall_E28_SBUS_RxFifo0Callback,
	DF_BSP_InterCall_TIM1_100ms_PeriodElapsedCallback,
	DF_BSP_InterCall_TIM8_2ms_PeriodElapsedCallback
};

uint8_t GF_BSP_Interrupt_Add_CallBack(enum DF_BSP_InterCall_Type _type,
		void (*_fn)(void));
void GF_BSP_Interrupt_Run_CallBack(enum DF_BSP_InterCall_Type _type);

#endif /* INC_BSP_INCLUDE_H_ */
