/*
 * BHBF_ROBOT.h
 *
 *  Created on: Oct 26, 2023
 *      Author: shiya
 */

#ifndef INC_BHBF_ROBOT_H_
#define INC_BHBF_ROBOT_H_

#include "bsp_include.h"

#include "bsp_PV.pb.h"

#include "bsp_UART.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "BHBF_ROBOT.h"

#include "pb.h"

#include "pb_decode.h"
#include "pb_encode.h"

#include "bsp_pb_decode_encode.h"

#include "msp_Steering_Engine.h"

#include "msp_fashion_star_uart_servo.h"




#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>

#include "msp_MK32_1.h"


#include "pb.h"
#include "pb_decode.h"
#include "pb_encode.h"
#include "bsp_pb_decode_encode.h"
#include "msp_Steering_Engine.h"

#include "msp_fashion_star_uart_servo.h"

#include "bsp_include.h"

#include "bsp_IV.pb.h"

#include"bsp_com_helper.h"

//#include "robot_state.h"
//FLASH (rx)     : ORIGIN = 0x08020000, LENGTH = 896K
//#define VECT_TAB_OFFSET         0x00020000U

//关键全局变量定义：GV、CV、PV
//其他变量定义：X1_X2_X3_X4
//X1：变量类型
//X2：所属层级 GL、MSP、BSP
//X3：所属模块
//X4：名称

//全局变量定义 X1=V
//宏定义 X1=DF
//结构体类型声明 X1=SP
//结构体定义 X1=ST
//指针类型定义 X1=P
//全局函数定义 X1=GF
//内部函数定义 X1为空，不要下划线，X2开头
//函数参数定义、函数局部变量定义  X1为空，下划线开头


#define DLTViewer 1


bool CompareTimer_Delay(int32_t Delay);




extern GV_struct_define GV;
//extern  PV_struct_define PV;
extern IV_struct_define IV;
extern  CV_struct_define CV;



typedef struct  sys_timer_handler
{
	int start_timer;
	int sys_current_timer_count;
	int sys_timer_flag;

}Sys_timer_handler;

extern Sys_timer_handler timer_handler_1;
extern Sys_timer_handler timer_handler_2;
extern Sys_timer_handler timer_handler_3;
extern Sys_timer_handler timer_handler_4;

//first start Timer, then WaitTimer
bool CompareTimer(int32_t DelayMiliSeconds,Sys_timer_handler * timer_handler);
void SystemTimer_Intialize();
void GF_Timer_Count();
void GF_Robot_Init(void);
void GF_Robot_MainLoop(void);
void GF_WatchDog_Loop(void);


 extern void SET_BIT_1(int32_t* num,int32_t k);

 extern void SET_BIT_0(int32_t* num,int32_t k);
 extern int32_t Get_BIT(int32_t* num,int32_t k);

//A &= ~(1 << bit)



extern MotorParameters *Motor[7];
extern int32_t *Motor_ID_Errors[7];
extern int32_t* SystemErrorCode;
extern ErrorData* SystemErrorData;
//Error Bit Define

#define AngleEncoderErrorBitFlag 		0
#define DAM_Relay_ErrorBitFlag 			1
#define DH_CAN_Remote_Controller_1E4 	2
#define DH_CAN_Remote_Controller_2E4	3
#define DH_Remote						4
#define force_sensor					5
#define LeiSai_ISV2CAN					6
#define mk32_sbus 						7
#define steering_engine					8
#define Weld_seam_Tracking				9

#define Ti5_1							11
#define Ti5_2							12
#define Ti5_3							13
#define Ti5_4							14
#define Ti5_5							15
#define Ti5_6							16

#define TL720D 							17


#define ZQ_CAN_ID1_LeftMotor			18
#define ZQ_CAN_ID2_RightMotor			19
#define ZQ_CAN_ID3_SwingMotor			20
#define wire_sensor						21

#define  DHRougheningController			22
#define DAM040D_Relay_ErrorBitFlag 		23

#define DMAKE_1 		24
#define DMAKE_2 		25
#define DMAKE_3 		26

#define KeLaiFen485 	27
#define KeLaiFenCAN 	28

#define LD150 29

#define mfog40_gyroscope 30

#define uwb_linkpg 30

#define KS206_sensor 31

#define Cmcu_Sensor 32


extern TT_MotorParameters* TT_Motor[4];




#endif /* INC_BHBF_ROBOT_H_ */
