/*
 * bsp_INTERCALL.c
 *
 *  Created on: 2023年11月8日
 *      Author: shiya
 */
#include "bsp_include.h"

typedef struct
 {
  uint8_t num;            //调用函数指针数量
  void(*fn[DF_BSP_InterCall_Num])(void);   //被调用函数指针,最多20个回调函数
 }SD_BSP_InterCall;

SD_BSP_InterCall V_BSP_InterCall_Array[DF_BSP_InterCall_Type_Num] = {0};

//给中断函数链接一个回调函数，直接添加空函数指针
//返回值1表示添加成功，返回值0表示添加失败
uint8_t GF_BSP_Interrupt_Add_CallBack(enum DF_BSP_InterCall_Type _type,void(*_fn)(void))
{
    V_BSP_InterCall_Array[_type].num++;
    if(V_BSP_InterCall_Array[_type].num>=DF_BSP_InterCall_Num)
    {
    	return 0;
    }
    V_BSP_InterCall_Array[_type].fn[V_BSP_InterCall_Array[_type].num-1]=_fn;
    return 1;
}

//放到中断函数中，运行相应的回调函数，有几个运行几个
void GF_BSP_Interrupt_Run_CallBack(enum DF_BSP_InterCall_Type _type)
{
    uint8_t i=0;
    if(V_BSP_InterCall_Array[_type].num>0)
    {
        for(i=0;i<V_BSP_InterCall_Array[_type].num;i++)
        {
            (*(V_BSP_InterCall_Array[_type].fn[i]))();
        }
    }
}
