import socket
import json
import time

import numpy as np
import math


# 连接机器人控制器
def connectETController(ip, port=8055):
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        sock.connect((ip, port))
        return (True, sock)
    except Exception as e:
        sock.close()
        return (False,)

# 发送命令并接收响应
def sendCMD(sock, cmd, params=None, id=1):
    if not params:
        params = []
    else:
        params = json.dumps(params)
    sendStr = '{"method":"%s","params":%s,"jsonrpc":"2.0","id":%d}' % (cmd, params, id) + "\n"
    try:
        sock.sendall(bytes(sendStr, "utf-8"))
        ret = sock.recv(1024)
        jdata = json.loads(str(ret, "utf-8"))
        if "result" in jdata.keys():
            return (True, json.loads(jdata["result"]), jdata["id"])
        elif "error" in jdata.keys():
            return (False, jdata["error"], jdata["id"])
        else:
            return (False, None, None)
    except Exception as e:
        return (False, None, None)

def send_Point(sock, cmd, params=None, id=1):
    if (not params):
        params = []
    else:
        params = json.dumps(params)
    sendStr = "{{\"method\":\"{0}\",\"params\":{1},\"jsonrpc\":\"2.0\",\"id\":{2}}}".format(cmd, params, id) + "\n"
    sock.sendall(bytes(sendStr, "utf-8"))

def wait_stop():
    while True:
        time.sleep(0.01)
        ret1, result1, id1 = sendCMD(sock, "getRobotState")  # getRobotstate
        if (ret1):
            if result1 == 0 or result1 == 4:
                break
            else:
                print("getRobotState failed")
                break

if __name__ == "__main__":
    # 机器人IP地址
    robot_ip = "192.168.1.100"
    result = connectETController(robot_ip)
    i = 0
    if len(result) == 2:
        conSuc, sock = result
        if conSuc:
            print("成功连接到机器人")
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "get_transparent_transmission_state")
            if  id== 1:
                print(suc, result, id)
                if result==1:
                    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
                    print("已清空透传缓存")
                    time.sleep(0.5)
                else:
                    print("无缓存")
        # 在此处做检测等相关操作
        # 在此处做检测等相关操作
        # 在此处做检测等相关操作，上电等相关操作
            suc, result, id = sendCMD(sock, "getRobotState")
            if (result == 4):
                # 清除报警
                suc, result, id = sendCMD(sock, "clearAlarm")
                time.sleep(0.5)

            # 获取同步状态
            suc, result, id = sendCMD(sock, "getMotorStatus")
            if (result == 0):
                # 同步伺服编码器数据
                suc, result, id = sendCMD(sock, "syncMotorStatus")
                time.sleep(0.5)
            else:
                print("同步状态获取失败")

            # 获取机械臂伺服状态
            suc, result, id = sendCMD(sock, "getServoStatus")
            if (result == 0):
                # 设置机械臂伺服状态ON
                suc, result, id = sendCMD(sock, "set_servo_status", {"status": 1})
                time.sleep(1)
            else:
                print("机械臂伺服取失败")


            # 获取当前机器人是否处于透传状态
            suc, result, id = sendCMD(sock, "get_transparent_transmission_state")
            print(result)
            if (result == 1):
                # 清空透传缓存
                suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
                time.sleep(0.5)
            else:
                print("非缓存状态")

            time.sleep(0.01)
            # 打开文件
            file_name = 'joint_positions_assembled_1.txt'
            fo = open(file_name, "r")
            while 1:
                # 依次读取文件的每一行(点位信息)
                line = fo.readline()
                if not line:
                    break
                # 去掉每行头尾空白
                line_list = line.strip()
                line_list = list(map(float, line_list.split(',')))
                # line_list=line_list +[1 2 3 0 0 0]
                increments = [0, 0, 0, 0, 0, 0]  #大臂车补偿误差
                modified_list = [val + inc for val, inc in zip(line_list, increments)]

                print(modified_list)
                if (i == 0):
                    # 关节运动到起始点
                    suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 80})
                    print(result)
                    wait_stop()  # 等待机器人停止
                    print(1)
                    # 初始化透传服务
                    suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                        "lookahead": 400, "t": 5, "smoothness":1, "response_enable": 0})
                    print(result)
                # 添加透传伺服目标关节点信息到缓存中
                send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
                print(result)
                time.sleep(0.01)
                i = i + 1
            # 关闭文件
            fo.close()
            print("第一段程序执行完")



            # 清空透传缓存
            i = 0
            suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
            time.sleep(2)
            print("第二段程序开始执行")
            file_name = 'Pose_1.txt'
            fo = open(file_name, "r")
            while 1:
                # 依次读取文件的每一行(点位信息)
                line = fo.readline()
                if not line:
                    break
                # 去掉每行头尾空白
                line_list = line.strip()
                line_list = list(map(float, line_list.split(',')))
                # line_list=line_list +[1 2 3 0 0 0]
                increments = [0, 0, 0, 0, 0, 0]
                modified_list = [val + inc for val, inc in zip(line_list, increments)]

                print(modified_list)
                if (i == 0):
                    # 关节运动到起始点
                    suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 80})
                    print(result)
                    wait_stop()  # 等待机器人停止
                    print(1)
                    # 初始化透传服务
                    suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                        "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
                    print(result)
                # 添加透传伺服目标关节点信息到缓存中
                send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPose": modified_list})
                print(result)
                time.sleep(0.01)
                i = i + 1
            # 关闭文件
            fo.close()
            print("第二段程序执行完")



            # 清空透传缓存
            i = 0
            suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
            time.sleep(4)
            print("第三段程序开始执行")
            file_name = 'joint_positions_assembled_1.txt'
            fo = open(file_name, "r")
            while 1:
                # 依次读取文件的每一行(点位信息)
                line = fo.readline()
                if not line:
                    break
                # 去掉每行头尾空白
                line_list = line.strip()
                line_list = list(map(float, line_list.split(',')))
                # line_list=line_list +[1 2 3 0 0 0]
                increments = [0, 0, 0, 0, 0, 0]
                modified_list = [val + inc for val, inc in zip(line_list, increments)]

                print(modified_list)
                if (i == 0):
                    # 关节运动到起始点
                    suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 80})
                    print(result)
                    wait_stop()  # 等待机器人停止
                    print(1)
                    # 初始化透传服务
                    suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                        "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
                    print(result)
                # 添加透传伺服目标关节点信息到缓存中
                send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
                print(result)
                time.sleep(0.01)
                i = i + 1
            # 关闭文件
            fo.close()


    else:
        print("无法连接到机器人")