import socket
import json
import time

import numpy as np
import math


# 连接机器人控制器
def connectETController(ip, port=8055):
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        sock.connect((ip, port))
        return (True, sock)
    except Exception as e:
        sock.close()
        return (False,)


# 发送命令并接收响应
def sendCMD(sock, cmd, params=None, id=1):
    if not params:
        params = []
    else:
        params = json.dumps(params)
    sendStr = '{"method":"%s","params":%s,"jsonrpc":"2.0","id":%d}' % (cmd, params, id) + "\n"
    try:
        sock.sendall(bytes(sendStr, "utf-8"))
        ret = sock.recv(1024)
        jdata = json.loads(str(ret, "utf-8"))
        if "result" in jdata.keys():
            return (True, json.loads(jdata["result"]), jdata["id"])
        elif "error" in jdata.keys():
            return (False, jdata["error"], jdata["id"])
        else:
            return (False, None, None)
    except Exception as e:
        return (False, None, None)


def send_Point(sock, cmd, params=None, id=1):
    if (not params):
        params = []
    else:
        params = json.dumps(params)
    sendStr = "{{\"method\":\"{0}\",\"params\":{1},\"jsonrpc\":\"2.0\",\"id\":{2}}}".format(cmd, params, id) + "\n"
    sock.sendall(bytes(sendStr, "utf-8"))


def wait_stop(sock):  # 修正：添加sock参数
    while True:
        time.sleep(0.01)
        ret1, result1, id1 = sendCMD(sock, "getRobotState")  # getRobotstate
        if (ret1):
            if result1 == 0 or result1 == 4:
                break
            else:
                print("getRobotState failed")
                break

#需要做8端程序，
# 第1段，起点处的关节位置（txt）；第2段，上升喷涂（txt）；
# 第3段，起点初的关节位置（txt）；第4段，上升喷涂（txt）；
# 第5段，起点初的关节位置（txt）；第6段，上升喷涂（txt）；
# 第7段，起点初的关节位置（txt）；第8段，上升喷涂（txt）；



# 第一段程序封装为函数
def program1(sock):
    # 初始化循环计数器i，用于记录处理的关节位置行数
    i = 0

    print("关闭喷枪")#关闭喷枪

    ###大臂车补偿量
    # 定义大臂车的位姿补偿量，前3个值为空间位置补偿，后3个为姿态补偿（此处姿态不补偿，均为0）
    increments = [100, 100, 100, 0, 0, 0]  # 大臂车的位姿误差只补偿空间位置不补偿姿态，所有后面3个都是0；
    ###大臂车补偿量
    # 初始化参考关节位置变量，用于存储第一组关节位置
    reference_pos = None  # 初始化参考位置
    # 初始化新关节位置变量，用于存储逆解计算得到的关节位置
    new_joint_pos = None  # 初始化逆解得到的新关节位置

    # 打开Pose_1.txt文件，以只读模式获取第一组末端位姿并计算目标位姿
    pose_file = open('Pose_1.txt', "r")
    # 读取文件第一行内容，并去除首尾的空白字符（包括换行符）
    first_pose_line = pose_file.readline().strip()  # 读取第一组位姿
    # 判断是否成功读取到第一行位姿数据
    if first_pose_line:
        # 将读取到的字符串按逗号分割，并转换为浮点数列表，得到原始路径的第一个位置
        Path_First_Position = list(map(float, first_pose_line.split(',')))
        # 将原始位置与补偿量逐元素相加，得到修正后的第一个位置
        Modified_First_Position = [val + inc for val, inc in zip(Path_First_Position, increments)]
        # 将修正后的位置赋值给target_pose，作为后续逆解计算的目标位姿
        target_pose = Modified_First_Position  # 将修改后的位姿列表 Modified_First_Position 赋值给 target_pose，作为目标位姿使用
    else:
        # 如果文件为空，打印错误信息
        print("Pose_1.txt为空，无法获取初始位姿")
        # 关闭文件
        pose_file.close()
        # 退出函数
        return
    # 关闭Pose_1.txt文件
    pose_file.close()

    # 定义关节位置文件的文件名
    file_name = 'joint_positions_assembled_1.txt'
    # 打开关节位置文件，以只读模式读取内容
    fo = open(file_name, "r")
    # 循环读取文件中的每一行内容
    while 1:
        # 读取一行内容
        line = fo.readline()
        # 如果读取到空行（文件结束），则跳出循环
        if not line:
            break
        # 去除行首尾的空白字符
        line_list = line.strip()
        # 将字符串按逗号分割，并转换为浮点数列表，得到当前行的关节位置数据
        line_list = list(map(float, line_list.split(',')))

        # 判断是否是第一组关节位置（reference_pos尚未赋值）
        if reference_pos is None:
            # 将第一组关节位置赋值给reference_pos，作为参考位置
            reference_pos = line_list  # A组关节位置赋值给参考位置
            # 调用逆解函数计算新的关节位置：发送"inverseKinematic"命令，参数为目标位姿和参考位置
            suc, angle, id = sendCMD(sock, "inverseKinematic", {"targetPose": target_pose, "referencePos": reference_pos})
            # 判断逆解是否成功且返回了有效的关节角度
            if suc and angle is not None:
                # 将逆解得到的关节位置保存到new_joint_pos
                new_joint_pos = angle  # 保存逆解得到的新关节位置
            else:
                # 如果逆解失败，打印提示信息
                print("逆解计算失败，使用原有关节位置")
                # 使用原始关节位置作为新关节位置
                new_joint_pos = line_list  # 失败时使用原位置

        # 确定当前行的修改后关节位置：优先使用逆解得到的新位置，若不存在则使用原始位置
        modified_list = new_joint_pos if new_joint_pos is not None else line_list

        # 打印当前行的修改后关节位置
        print(modified_list)
        # 判断是否是第一行关节位置（i=0表示首次处理）
        if (i == 0):
            # 发送关节运动命令，将机器人移动到起始点，速度设置为100
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            # 打印运动命令的执行结果
            print(result)
            # 等待机器人停止运动
            wait_stop(sock)  # 等待机器人停止
            # 打印提示信息，标识已完成起始点运动
            print(1)
            # 初始化透传服务：设置前瞻距离400、时间5、平滑度1、禁用响应
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
            # 打印透传初始化的结果
            print(result)
        # 发送当前关节点信息到透传缓存，用于后续的伺服控制
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
        # 打印上一条命令的执行结果（注：此处result可能还是透传初始化的结果，需注意是否需要更新）
        print(result)
        # 暂停0.01秒，控制数据发送频率
        time.sleep(0.01)
        # 循环计数器加1，记录已处理的行数
        i = i + 1
    # 关闭关节位置文件
    fo.close()
    # 打印提示信息，标识第一段程序执行完毕
    print("第一段程序执行完")



# 第二段程序封装为函数
def program2(sock):
    i = 0
    # 清空透传缓存
    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
    time.sleep(0)
    print("第二段程序开始执行")
    file_name = 'Pose_1.txt'
    fo = open(file_name, "r")
    while 1:
        line = fo.readline()
        if not line:
            break
        line_list = line.strip()
        line_list = list(map(float, line_list.split(',')))
        increments = [100, 100, 100, 0, 0, 0]
        modified_list = [val + inc for val, inc in zip(line_list, increments)]

        print(modified_list)
        if (i == 0):
            # 关节运动到起始点
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            print(result)
            wait_stop(sock)  # 等待机器人停止
            print(1)
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 100, "t": 100, "smoothness": 1, "response_enable": 0})
            print(result)
        # 添加透传伺服目标关节点信息到缓存中
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPose": modified_list})

        print(result)
        time.sleep(0.1)

        if(i >= 20 and i <= 25):
            print("打开喷枪")#开喷枪
        if(i >= 180 and i <= 185):
            print("关闭喷枪")#关喷枪

        i = i + 1
    fo.close()
    print("第二段程序执行完")

# 第三段程序封装为函数，hjb改
def program3(sock):
    # 初始化循环计数器i，用于记录处理的关节位置行数
    i = 0
    ###大臂车补偿量
    # 定义大臂车的位姿补偿量，前3个值为空间位置补偿，后3个为姿态补偿（此处姿态不补偿，均为0）
    increments = [100, 100, 100, 0, 0, 0]  # 大臂车的位姿误差只补偿空间位置不补偿姿态，所有后面3个都是0；
    ###大臂车补偿量
    # 初始化参考关节位置变量，用于存储第一组关节位置
    reference_pos = None  # 初始化参考位置
    # 初始化新关节位置变量，用于存储逆解计算得到的关节位置
    new_joint_pos = None  # 初始化逆解得到的新关节位置

    # 打开Pose_1.txt文件，以只读模式获取第一组末端位姿并计算目标位姿
    pose_file = open('Pose_2.txt', "r")
    # 读取文件第一行内容，并去除首尾的空白字符（包括换行符）
    first_pose_line = pose_file.readline().strip()  # 读取第一组位姿
    # 判断是否成功读取到第一行位姿数据
    if first_pose_line:
        # 将读取到的字符串按逗号分割，并转换为浮点数列表，得到原始路径的第一个位置
        Path_First_Position = list(map(float, first_pose_line.split(',')))
        # 将原始位置与补偿量逐元素相加，得到修正后的第一个位置
        Modified_First_Position = [val + inc for val, inc in zip(Path_First_Position, increments)]
        # 将修正后的位置赋值给target_pose，作为后续逆解计算的目标位姿
        target_pose = Modified_First_Position  # 将修改后的位姿列表 Modified_First_Position 赋值给 target_pose，作为目标位姿使用
    else:
        # 如果文件为空，打印错误信息
        print("Pose_2.txt为空，无法获取初始位姿")
        # 关闭文件
        pose_file.close()
        # 退出函数
        return
    # 关闭Pose_1.txt文件
    pose_file.close()

    # 定义关节位置文件的文件名
    file_name = 'joint_positions_assembled_2.txt'
    # 打开关节位置文件，以只读模式读取内容
    fo = open(file_name, "r")
    # 循环读取文件中的每一行内容
    while 1:
        # 读取一行内容
        line = fo.readline()
        # 如果读取到空行（文件结束），则跳出循环
        if not line:
            break
        # 去除行首尾的空白字符
        line_list = line.strip()
        # 将字符串按逗号分割，并转换为浮点数列表，得到当前行的关节位置数据
        line_list = list(map(float, line_list.split(',')))

        # 判断是否是第一组关节位置（reference_pos尚未赋值）
        if reference_pos is None:
            # 将第一组关节位置赋值给reference_pos，作为参考位置
            reference_pos = line_list  # A组关节位置赋值给参考位置
            # 调用逆解函数计算新的关节位置：发送"inverseKinematic"命令，参数为目标位姿和参考位置
            suc, angle, id = sendCMD(sock, "inverseKinematic", {"targetPose": target_pose, "referencePos": reference_pos})
            # 判断逆解是否成功且返回了有效的关节角度
            if suc and angle is not None:
                # 将逆解得到的关节位置保存到new_joint_pos
                new_joint_pos = angle  # 保存逆解得到的新关节位置
            else:
                # 如果逆解失败，打印提示信息
                print("逆解计算失败，使用原有关节位置")
                # 使用原始关节位置作为新关节位置
                new_joint_pos = line_list  # 失败时使用原位置

        # 确定当前行的修改后关节位置：优先使用逆解得到的新位置，若不存在则使用原始位置
        modified_list = new_joint_pos if new_joint_pos is not None else line_list

        # 打印当前行的修改后关节位置
        print(modified_list)
        # 判断是否是第一行关节位置（i=0表示首次处理）
        if (i == 0):
            # 发送关节运动命令，将机器人移动到起始点，速度设置为100
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            # 打印运动命令的执行结果
            print(result)
            # 等待机器人停止运动
            wait_stop(sock)  # 等待机器人停止
            # 打印提示信息，标识已完成起始点运动
            print(1)
            # 初始化透传服务：设置前瞻距离400、时间5、平滑度1、禁用响应
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
            # 打印透传初始化的结果
            print(result)
        # 发送当前关节点信息到透传缓存，用于后续的伺服控制
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
        # 打印上一条命令的执行结果（注：此处result可能还是透传初始化的结果，需注意是否需要更新）
        print(result)
        # 暂停0.01秒，控制数据发送频率
        time.sleep(0.01)
        # 循环计数器加1，记录已处理的行数
        i = i + 1
    # 关闭关节位置文件
    fo.close()
    # 打印提示信息，标识第一段程序执行完毕
    print("第三段程序执行完")

# 第四段程序封装为函数
def program4(sock):
    i = 0
    # 清空透传缓存
    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
    time.sleep(0)
    print("第四段程序开始执行")
    file_name = 'Pose_2.txt'
    fo = open(file_name, "r")
    while 1:
        line = fo.readline()
        if not line:
            break
        line_list = line.strip()
        line_list = list(map(float, line_list.split(',')))
        increments = [100, 100, 100, 0, 0, 0]
        modified_list = [val + inc for val, inc in zip(line_list, increments)]

        print(modified_list)
        if (i == 0):
            # 关节运动到起始点
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            print(result)
            wait_stop(sock)  # 等待机器人停止
            print(1)
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 100, "t": 50, "smoothness": 1, "response_enable": 0})
            print(result)
        # 添加透传伺服目标关节点信息到缓存中
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPose": modified_list})

        print(result)
        time.sleep(0.005)
        i = i + 1
    fo.close()
    print("第四段程序执行完")

# 第五段程序封装为函数，hjb改
def program5(sock):
    # 初始化循环计数器i，用于记录处理的关节位置行数
    i = 0

    print("关闭喷枪")  # 关喷枪

    ###大臂车补偿量
    # 定义大臂车的位姿补偿量，前3个值为空间位置补偿，后3个为姿态补偿（此处姿态不补偿，均为0）
    increments = [100, 100, 100, 0, 0, 0]  # 大臂车的位姿误差只补偿空间位置不补偿姿态，所有后面3个都是0；
    ###大臂车补偿量
    # 初始化参考关节位置变量，用于存储第一组关节位置
    reference_pos = None  # 初始化参考位置
    # 初始化新关节位置变量，用于存储逆解计算得到的关节位置
    new_joint_pos = None  # 初始化逆解得到的新关节位置

    # 打开Pose_1.txt文件，以只读模式获取第一组末端位姿并计算目标位姿
    pose_file = open('Pose_3.txt', "r")
    # 读取文件第一行内容，并去除首尾的空白字符（包括换行符）
    first_pose_line = pose_file.readline().strip()  # 读取第一组位姿
    # 判断是否成功读取到第一行位姿数据
    if first_pose_line:
        # 将读取到的字符串按逗号分割，并转换为浮点数列表，得到原始路径的第一个位置
        Path_First_Position = list(map(float, first_pose_line.split(',')))
        # 将原始位置与补偿量逐元素相加，得到修正后的第一个位置
        Modified_First_Position = [val + inc for val, inc in zip(Path_First_Position, increments)]
        # 将修正后的位置赋值给target_pose，作为后续逆解计算的目标位姿
        target_pose = Modified_First_Position  # 将修改后的位姿列表 Modified_First_Position 赋值给 target_pose，作为目标位姿使用
    else:
        # 如果文件为空，打印错误信息
        print("Pose_3.txt为空，无法获取初始位姿")
        # 关闭文件
        pose_file.close()
        # 退出函数
        return
    # 关闭Pose_1.txt文件
    pose_file.close()

    # 定义关节位置文件的文件名
    file_name = 'joint_positions_assembled_3.txt'
    # 打开关节位置文件，以只读模式读取内容
    fo = open(file_name, "r")
    # 循环读取文件中的每一行内容
    while 1:
        # 读取一行内容
        line = fo.readline()
        # 如果读取到空行（文件结束），则跳出循环
        if not line:
            break
        # 去除行首尾的空白字符
        line_list = line.strip()
        # 将字符串按逗号分割，并转换为浮点数列表，得到当前行的关节位置数据
        line_list = list(map(float, line_list.split(',')))

        # 判断是否是第一组关节位置（reference_pos尚未赋值）
        if reference_pos is None:
            # 将第一组关节位置赋值给reference_pos，作为参考位置
            reference_pos = line_list  # A组关节位置赋值给参考位置
            # 调用逆解函数计算新的关节位置：发送"inverseKinematic"命令，参数为目标位姿和参考位置
            suc, angle, id = sendCMD(sock, "inverseKinematic",
                                     {"targetPose": target_pose, "referencePos": reference_pos})
            # 判断逆解是否成功且返回了有效的关节角度
            if suc and angle is not None:
                # 将逆解得到的关节位置保存到new_joint_pos
                new_joint_pos = angle  # 保存逆解得到的新关节位置
            else:
                # 如果逆解失败，打印提示信息
                print("逆解计算失败，使用原有关节位置")
                # 使用原始关节位置作为新关节位置
                new_joint_pos = line_list  # 失败时使用原位置

        # 确定当前行的修改后关节位置：优先使用逆解得到的新位置，若不存在则使用原始位置
        modified_list = new_joint_pos if new_joint_pos is not None else line_list

        # 打印当前行的修改后关节位置
        print(modified_list)
        # 判断是否是第一行关节位置（i=0表示首次处理）
        if (i == 0):
            # 发送关节运动命令，将机器人移动到起始点，速度设置为100
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            # 打印运动命令的执行结果
            print(result)
            # 等待机器人停止运动
            wait_stop(sock)  # 等待机器人停止
            # 打印提示信息，标识已完成起始点运动
            print(1)
            # 初始化透传服务：设置前瞻距离400、时间5、平滑度1、禁用响应
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
            # 打印透传初始化的结果
            print(result)
        # 发送当前关节点信息到透传缓存，用于后续的伺服控制
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
        # 打印上一条命令的执行结果（注：此处result可能还是透传初始化的结果，需注意是否需要更新）
        print(result)
        # 暂停0.01秒，控制数据发送频率
        time.sleep(0.01)
        # 循环计数器加1，记录已处理的行数
        i = i + 1
    # 关闭关节位置文件
    fo.close()
    # 打印提示信息，标识第三段程序执行完毕
    print("第五段程序执行完")

# 第六段程序封装为函数
def program6(sock):
    i = 0
    # 清空透传缓存
    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
    time.sleep(0)
    print("第六段程序开始执行")
    file_name = 'Pose_3.txt'
    fo = open(file_name, "r")
    while 1:
        line = fo.readline()
        if not line:
            break
        line_list = line.strip()
        line_list = list(map(float, line_list.split(',')))
        increments = [100, 100, 100, 0, 0, 0]
        modified_list = [val + inc for val, inc in zip(line_list, increments)]

        print(modified_list)
        if (i == 0):
            # 关节运动到起始点
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            print(result)
            wait_stop(sock)  # 等待机器人停止
            print(1)
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 100, "t": 100, "smoothness": 1, "response_enable": 0})
            print(result)
        # 添加透传伺服目标关节点信息到缓存中
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPose": modified_list})

        print(result)
        time.sleep(0.1)

        if(i >= 20 and i <= 25):
            print("打开喷枪")#开喷枪
        if(i >= 180 and i <= 185):
            print("关闭喷枪")#关喷枪

        i = i + 1
    fo.close()
    print("第六段程序执行完")


    # 第七段程序封装为函数，hjb改
def program7(sock):
    # 初始化循环计数器i，用于记录处理的关节位置行数
    i = 0
    ###大臂车补偿量
    # 定义大臂车的位姿补偿量，前3个值为空间位置补偿，后3个为姿态补偿（此处姿态不补偿，均为0）
    increments = [100, 100, 100, 0, 0, 0]  # 大臂车的位姿误差只补偿空间位置不补偿姿态，所有后面3个都是0；
    ###大臂车补偿量
    # 初始化参考关节位置变量，用于存储第一组关节位置
    reference_pos = None  # 初始化参考位置
    # 初始化新关节位置变量，用于存储逆解计算得到的关节位置
    new_joint_pos = None  # 初始化逆解得到的新关节位置

    # 打开Pose_1.txt文件，以只读模式获取第一组末端位姿并计算目标位姿
    pose_file = open('Pose_4.txt', "r")
    # 读取文件第一行内容，并去除首尾的空白字符（包括换行符）
    first_pose_line = pose_file.readline().strip()  # 读取第一组位姿
    # 判断是否成功读取到第一行位姿数据
    if first_pose_line:
        # 将读取到的字符串按逗号分割，并转换为浮点数列表，得到原始路径的第一个位置
        Path_First_Position = list(map(float, first_pose_line.split(',')))
        # 将原始位置与补偿量逐元素相加，得到修正后的第一个位置
        Modified_First_Position = [val + inc for val, inc in zip(Path_First_Position, increments)]
        # 将修正后的位置赋值给target_pose，作为后续逆解计算的目标位姿
        target_pose = Modified_First_Position  # 将修改后的位姿列表 Modified_First_Position 赋值给 target_pose，作为目标位姿使用
    else:
        # 如果文件为空，打印错误信息
        print("Pose_4.txt为空，无法获取初始位姿")
        # 关闭文件
        pose_file.close()
        # 退出函数
        return
    # 关闭Pose_1.txt文件
    pose_file.close()

    # 定义关节位置文件的文件名
    file_name = 'joint_positions_assembled_4.txt'
    # 打开关节位置文件，以只读模式读取内容
    fo = open(file_name, "r")
    # 循环读取文件中的每一行内容
    while 1:
        # 读取一行内容
        line = fo.readline()
        # 如果读取到空行（文件结束），则跳出循环
        if not line:
            break
        # 去除行首尾的空白字符
        line_list = line.strip()
        # 将字符串按逗号分割，并转换为浮点数列表，得到当前行的关节位置数据
        line_list = list(map(float, line_list.split(',')))

        # 判断是否是第一组关节位置（reference_pos尚未赋值）
        if reference_pos is None:
            # 将第一组关节位置赋值给reference_pos，作为参考位置
            reference_pos = line_list  # A组关节位置赋值给参考位置
            # 调用逆解函数计算新的关节位置：发送"inverseKinematic"命令，参数为目标位姿和参考位置
            suc, angle, id = sendCMD(sock, "inverseKinematic",
                                     {"targetPose": target_pose, "referencePos": reference_pos})
            # 判断逆解是否成功且返回了有效的关节角度
            if suc and angle is not None:
                # 将逆解得到的关节位置保存到new_joint_pos
                new_joint_pos = angle  # 保存逆解得到的新关节位置
            else:
                # 如果逆解失败，打印提示信息
                print("逆解计算失败，使用原有关节位置")
                # 使用原始关节位置作为新关节位置
                new_joint_pos = line_list  # 失败时使用原位置

        # 确定当前行的修改后关节位置：优先使用逆解得到的新位置，若不存在则使用原始位置
        modified_list = new_joint_pos if new_joint_pos is not None else line_list

        # 打印当前行的修改后关节位置
        print(modified_list)
        # 判断是否是第一行关节位置（i=0表示首次处理）
        if (i == 0):
            # 发送关节运动命令，将机器人移动到起始点，速度设置为100
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            # 打印运动命令的执行结果
            print(result)
            # 等待机器人停止运动
            wait_stop(sock)  # 等待机器人停止
            # 打印提示信息，标识已完成起始点运动
            print(1)
            # 初始化透传服务：设置前瞻距离400、时间5、平滑度1、禁用响应
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 400, "t": 5, "smoothness": 1, "response_enable": 0})
            # 打印透传初始化的结果
            print(result)
        # 发送当前关节点信息到透传缓存，用于后续的伺服控制
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPos": modified_list})
        # 打印上一条命令的执行结果（注：此处result可能还是透传初始化的结果，需注意是否需要更新）
        print(result)
        # 暂停0.01秒，控制数据发送频率
        time.sleep(0.01)
        # 循环计数器加1，记录已处理的行数
        i = i + 1
    # 关闭关节位置文件
    fo.close()
    # 打印提示信息，标识第三段程序执行完毕
    print("第七段程序执行完")

# 第八段程序封装为函数
def program8(sock):
    i = 0
    # 清空透传缓存
    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
    time.sleep(0)
    print("第八段程序开始执行")
    file_name = 'Pose_4.txt'
    fo = open(file_name, "r")
    while 1:
        line = fo.readline()
        if not line:
            break
        line_list = line.strip()
        line_list = list(map(float, line_list.split(',')))
        increments = [100, 100, 100, 0, 0, 0]
        modified_list = [val + inc for val, inc in zip(line_list, increments)]

        print(modified_list)
        if (i == 0):
            # 关节运动到起始点
            suc, result, id = sendCMD(sock, "moveByJoint", {"targetPos": modified_list, "speed": 100})
            print(result)
            wait_stop(sock)  # 等待机器人停止
            print(1)
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "transparent_transmission_init", {
                "lookahead": 100, "t": 100, "smoothness": 1, "response_enable": 0})
            print(result)
        # 添加透传伺服目标关节点信息到缓存中
        send_Point(sock, "tt_put_servo_joint_to_buf", {"targetPose": modified_list})

        print(result)
        time.sleep(0.1)
        i = i + 1
    fo.close()
    print("第八段程序执行完")



if __name__ == "__main__":
    # 机器人IP地址
    robot_ip = "192.168.1.100"
    result = connectETController(robot_ip)
    sock = None
    if len(result) == 2:
        conSuc, sock = result
        if conSuc:
            print("成功连接到机器人")
            # 初始化透传服务
            suc, result, id = sendCMD(sock, "get_transparent_transmission_state")
            if id == 1:
                print(suc, result, id)
                if result == 1:
                    suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
                    print("已清空透传缓存")
                    time.sleep(0.5)
                else:
                    print("无缓存")

            # 在此处做检测等相关操作
            suc, result, id = sendCMD(sock, "getRobotState")
            if (result == 4):
                # 清除报警
                suc, result, id = sendCMD(sock, "clearAlarm")
                time.sleep(0.5)

            # 获取同步状态
            suc, result, id = sendCMD(sock, "getMotorStatus")
            if (result == 0):
                # 同步伺服编码器数据
                suc, result, id = sendCMD(sock, "syncMotorStatus")
                time.sleep(0.5)
            else:
                print("同步状态获取失败")

            # 获取机械臂伺服状态
            suc, result, id = sendCMD(sock, "getServoStatus")
            if (result == 0):
                # 设置机械臂伺服状态ON
                suc, result, id = sendCMD(sock, "set_servo_status", {"status": 1})
                time.sleep(1)
            else:
                print("机械臂伺服取失败")

            # 获取当前机器人是否处于透传状态
            suc, result, id = sendCMD(sock, "get_transparent_transmission_state")
            print(result)
            if (result == 1):
                # 清空透传缓存
                suc, result, id = sendCMD(sock, "tt_clear_servo_joint_buf")
                time.sleep(0.5)
            else:
                print("非缓存状态")

            time.sleep(0.01)
            print("初始化完成，等待指令...")

            # 用字典模拟switch-case逻辑
            program_switch = {
                1: program1,
                2: program2,
                #3: program3,  # 保留第三段程序的选择入口
                #4: program4,
                5: program5,
                6: program6
            }

            # 循环等待用户输入选择
            while True:
                try:
                    choice = input("\n请选择执行的程序 (1-第一段, 2-第二段, 3-第三段,4-第四段,5-第五段,6-第六段, q-退出): ")
                    if choice.lower() == 'q':
                        print("程序退出")
                        break
                    choice_num = int(choice)
                    if choice_num in program_switch:
                        program_switch[choice_num](sock)  # 执行对应程序
                    else:
                        print("无效选择，请输入1、2、3或q")
                except ValueError:
                    print("输入错误，请输入数字或q")
        else:
            print("连接机器人失败")
    else:
        print("无法连接到机器人")

    # 关闭连接
    if sock:
        sock.close()