/*
 * bsp_com_helper.c
 *
 *  Created on: Oct 9, 2024
 *      Author: akeguo
 */
#include "bsp_com_helper.h"
#include <stdlib.h>
//#include "DLT/DLTuc.h"
#include "BHBF_ROBOT.h"

void Dispatch_t(DispacherController *uartHandler)
{
//2ms

	if (uartHandler->Dispacher_Enable == 1)
	{
		if (uartHandler->DispacherNumber > 0)              //列表中有数据
		{
			uartHandler->Dispacher_Counter++;

			if (uartHandler->Dispacher_Counter>= uartHandler->DispacherCallTime / 2
												/ (uartHandler->DispacherNumber))        //多长时间运行一次
			{
				uartHandler->Dispacher_Counter = 0;
				if (uartHandler->pHead != NULL
						&& uartHandler->pHead->pNext != NULL)
				{

					uartHandler->pHead->dispache();        //执行函数

					uartHandler->pHead = uartHandler->pHead->pNext;

				} else
				{

				}
			}
		}

	}
}

void Dispatcher_List_Add_t(DispacherController *uartHandler,
						   void (*dispache)(void))
{
	Dispatcher *pTmp = NULL; //临时指针2

	if (uartHandler->pHead == NULL && uartHandler->pTail == NULL)              //头尾部都为空
	{
		uartHandler->pHead = uartHandler->pTail = (Dispatcher*) malloc(
				sizeof(Dispatcher));
		uartHandler->pHead->dispache = dispache;
		uartHandler->pTail->dispache = dispache;

		uartHandler->pHead->pNext = uartHandler->pTail;

		uartHandler->pTail->pNext = uartHandler->pHead;
		uartHandler->DispacherNumber++;
	} else
	{
		pTmp = (Dispatcher*) malloc(sizeof(Dispatcher));
		pTmp->dispache = dispache;


		pTmp->pNext = uartHandler->pHead;          //新节点的下一个节点指向头节点
		uartHandler->pTail->pNext = pTmp;          //原尾节点的下一个节点指向新节点
		uartHandler->pTail = pTmp;                 //更新为节点为新节点
		uartHandler->DispacherNumber++;
	}
}

void ComHardWare_List_Add_t(HardWareController *uartHandler, char *name,
		char value,uint32_t bitFlag)
{

	ComHardWare *pTmp = NULL; //临时指针2
	if (uartHandler->pComHWHead == NULL && uartHandler->pComHWTail == NULL) //头尾部都为空
	{
		uartHandler->pComHWHead = uartHandler->pComHWTail =
				(ComHardWare*) malloc(sizeof(ComHardWare));

		memset(uartHandler->pComHWHead->Name, '\0',
				sizeof(uartHandler->pComHWHead->Name));
		memcpy(uartHandler->pComHWHead->Name, name, strlen(name));
		uartHandler->pComHWHead->IsOnline = value;
		uartHandler->pComHWHead->BitFlag = bitFlag;
		uartHandler->pComHWHead->pNext = NULL;
	} else
	{

		pTmp = (ComHardWare*) malloc(sizeof(ComHardWare));
		memset(pTmp->Name, '\0', sizeof(pTmp->Name));
		memcpy(pTmp->Name, name, strlen(name));

		pTmp->BitFlag = bitFlag;
		pTmp->IsOnline = value;
		pTmp->pNext = NULL; //set the new dispatcher .next to the header, thus make it a circle
		uartHandler->pComHWTail->pNext = pTmp;
		uartHandler->pComHWTail = pTmp;

	}

}
char str1[50] = "\0";
void PCOMHardWare_Check_t(HardWareController *uartHandler)
{
	uartHandler->HardWare_Check_Counter++;
//	if (uartHandler->HardWare_Check_Counter*2
//			>= uartHandler->DispacherCallTime * 6)	//make sure every
	if (uartHandler->HardWare_Check_Counter * 2 >= uartHandler->DispacherCallTime)	//make sure every
	{
		ComHardWare *ptr = uartHandler->pComHWHead;

		if (!ptr)
		{
			uartHandler->HardWare_Check_Counter = 0;
			//printf("链表为空\n");
			return;
		}
		char IsAbnornalStatus = 0;

		//check invalid state
		while (ptr != NULL)
		{
			if (ptr->IsOnline != 1)
			{
				memset(str1, '\0', 50);
				memcpy(str1, ptr->Name, strlen(ptr->Name));
//				LOGFF(DL_ERROR, "connecting Error %s", ptr->Name);
				SET_BIT_1(SystemErrorCode,ptr->BitFlag);
				//*SystemErrorCode=*SystemErrorCode|(1<<ptr->BitFlag);
				IsAbnornalStatus = 1;
			}else
			{
				//*SystemErrorCode=*SystemErrorCode|(1<<ptr->BitFlag);
				SET_BIT_0(SystemErrorCode,ptr->BitFlag);
			}
			ptr = ptr->pNext;
		}

		//set invalid state
		ptr = uartHandler->pComHWHead;
		while (ptr != NULL)
		{
			ptr->IsOnline = 0;
			ptr = ptr->pNext;
		}
		uartHandler->HardWare_Check_Counter = 0;//perform the check of connection
	}
}

int Set_PCOMHardWare_t(HardWareController *uartHandler, char *name, char value)
{

	ComHardWare *ptr = uartHandler->pComHWHead;
	char finddata = 0;

	if (ptr == NULL)
	{

		return 0;
	}

	while (ptr != NULL)
	{
		if (strcmp(ptr->Name, name) == 0)
		{
			ptr->IsOnline = value;
			finddata = 1;
			return finddata;
		} else
		{
			ptr = ptr->pNext;
		}

	}
	return finddata;

}

