#ifndef __BSP_MB_HOST_H__
#define __BSP_MB_HOST_H__

/* 包含头文件 ----------------------------------------------------------------*/

/* 类型定义 ------------------------------------------------------------------*/

/* 宏定义 --------------------------------------------------------------------*/
#define MB_SLAVEADDR        0x0001 //从机地址
#define MB_REG_ADDR         0 //寄存器地址（离散、线圈）
#define HoldingReg          0 //保持寄存器
#define InputRegReg         0x0020 //输入寄存器
#include "bsp_include.h"
#include "bsp_UART.h"

/* 扩展变量 ------------------------------------------------------------------*/
 typedef struct
{

	uint16_t DATA_01H;
	uint16_t DATA_02H;
	uint16_t DATA_03H;

	uint16_t DATA_04H;
	uint16_t DATA_05H;
	uint16_t DATA_06H;
	uint8_t DATA_10H[64];

}MB_REG_DATA;

//;
extern uint8_t MB_rx_flag;
extern uint16_t Read_Reg_Num;

/* 函数声明 ------------------------------------------------------------------*/
uint16_t MB_CRC16(uint8_t *pushMsg, uint16_t usDataLen);
void MB_ReadCoil(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _num);
void MB_WriteCoil(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _sta);
void MB_ReadInput(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _num);
void MB_ReadHoldingReg(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _num);
void MB_ReadInputReg(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _num);
void MB_WriteHoldingReg(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _data);
//void MB_WriteNumHoldingReg(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _num,uint8_t *_databuf)
void MB_WriteNumHoldingReg(uint8_t* Tx_Buf,uint8_t* TxCount_t,uint8_t _addr, uint16_t _reg, uint16_t _num,uint8_t *_databuf);
void MB_WriteNumCoil(uint8_t *Tx_Buf, uint8_t *TxCount_t, uint8_t _addr,
		uint16_t _reg, uint16_t _num, uint8_t *_databuf);

#endif /* __BSP_MB_HOST_H__ */

/******************* (C) COPYRIGHT 2015-2020 硬石嵌入式开发团队 *****END OF FILE****/
