/*
 * bsp_steering_engine.h
 *
 *  Created on: Jul 29, 2024
 *      Author: akeguo
 */

#ifndef INC_MSP_MSP_STEERING_ENGINE_H_
#define INC_MSP_MSP_STEERING_ENGINE_H_

#include <stdio.h>
#include <string.h>
#include "stdio.h"
#include "bsp_UART.h"
#include "usart.h"
#include "gpio.h"


extern int32_t* Desulfurizer_Steering_Set_Speed_1;
extern int32_t* Desulfurizer_Steering_Set_Speed_2;
extern int32_t* Desulfurizer_Steering_Set_Speed_3;
extern int32_t* Desulfurizer_Steering_Set_Speed_4;
extern int32_t* Desulfurizer_Steering_Angle_3;
extern int32_t* Desulfurizer_Steering_Angle_4;
extern int32_t* Desulfurizer_Steering_Current;
extern int32_t* Desulfurizer_Steering_Real_Angle;
extern int32_t* Desulfurizer_Steering_Real_Angle_3;
extern int32_t* Desulfurizer_Steering_Real_Angle_4;

extern int32_t* Steering_damping_power_1;
extern int32_t* Steering_damping_power_2;
extern int32_t* Steering_damping_power_3;
extern int32_t* Steering_damping_power_4;

void setSteeringRobotProtectionMode();
void Clear_current_laps();
void update_steering_state();
void steering_engine_intialize(struct UARTHandler *Handler);
void steering_engine_intialize_12(struct UARTHandler *Handler);

void read_steering_Angle();
void steering_homing_control();
void SteeringDampingPowerControl(uint8_t steering_id1,
								 int32_t Steering_damping_power);

//FSUS_STATUS FSUS_ReadData(uint8_t servo_id, uint8_t address, uint8_t *sendbytes, uint8_t *length);
void read_steering_current();
void decode_steering_angle_03(uint8_t *buffer, uint16_t length);
#endif /* INC_MSP_MSP_STEERING_ENGINE_H_ */
